/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.js.core.model.BaseElement;
import com.aptana.js.core.model.EventPropertyElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventElement
extends BaseElement {
    private static final String OWNING_TYPE_PROPERTY = "owningType";
    private static final String PROPERTIES_PROPERTY = "properties";
    private String _owningType;
    private List<EventPropertyElement> _properties;

    public void addProperty(EventPropertyElement property) {
        if (property != null) {
            if (this._properties == null) {
                this._properties = new ArrayList<EventPropertyElement>();
            }
            this._properties.add(property);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        if (object.containsKey(PROPERTIES_PROPERTY)) {
            List properties = IndexUtil.createList(object.get(PROPERTIES_PROPERTY), EventPropertyElement.class);
            if (CollectionsUtil.isEmpty((Collection)properties)) {
                return;
            }
            for (EventPropertyElement property : properties) {
                this.addProperty(property);
            }
        }
    }

    public String getOwningType() {
        return StringUtil.getStringValue((Object)this._owningType);
    }

    public List<EventPropertyElement> getProperties() {
        return CollectionsUtil.getListValue(this._properties);
    }

    public void setOwningType(String type) {
        this._owningType = type;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(OWNING_TYPE_PROPERTY, (Object)this.getOwningType());
        out.add(PROPERTIES_PROPERTY, this.getProperties());
    }

    @Override
    public void toSource(SourcePrinter printer) {
        printer.printIndent();
        printer.print("event ");
        printer.print(this.getName());
        printer.println(" {");
        printer.increaseIndent();
        for (EventPropertyElement property : this.getProperties()) {
            property.toSource(printer);
            printer.println(';');
        }
        printer.decreaseIndent();
        printer.printWithIndent('}');
    }
}

